define(['underscore', 'backbone'], function (_, Backbone) {
    'use strict';

    // model
    return Backbone.Model.extend({
        defaults: {
            'idPrefix': '',
            'disabled': false,
            'required': false,
        },
        initialize: function() {
            this.setDefaultValuesForType(this.get('type'));
        },

        // eslint-disable-next-line complexity
        setDefaultValuesForType: function(type) {
            // eslint-disable-next-line default-case
            switch (type) {
            case 'checkbox':
                /* falls through */
            case 'radio':
                /* falls through */
            case 'toggle':
                /* falls through */
            case 'select':
                this.set(_.extend({selected: ''}, this.attributes));
                break;
            case 'tel':
                /* falls through */
            case 'email':
                /* falls through */
            case 'text':
                /* falls through */
            case 'textarea':
                this.set(_.extend({
                    placeholder: '',
                    value: '',
                    // maxlength: "-1" // negative number for default behaviour
                    maxlength: '524228', // IE does not like maxlength -1
                }, this.attributes));
                break;
            case 'text-datepicker':
                this.set(_.extend({
                    value: '',
                    descriptionTemplate: '', // default none
                    min: '01/01/1900',
                    max: '12/31/2099',
                }, this.attributes));
                break;
            case 'number':
                this.set(_.extend({
                    placeholder: '',
                    value: '',
                    min: '0',
                }, this.attributes));
                break;
            case 'button':
                this.set(_.extend({dataIcon: ''}, this.attributes));
                break;

            }
        },
    });
});
